<?php

return [
    'accepted' => ':attribute musí být akceptován.',
    'accepted_if' => ':attribute musí být akceptován, když :other je :value.',
    'active_url' => ':attribute není platná adresa URL.',
    'after' => ':attribute musí být datum po :date.',
    'after_or_equal' => ':attribute musí být datum rovné nebo následující po :date.',
    'alpha' => ':attribute musí obsahovat pouze písmena.',
    'alpha_dash' => ':attribute musí obsahovat pouze písmena, čísla, pomlčky a podtržítka.',
    'alpha_num' => ':attribute musí obsahovat pouze písmena a čísla.',
    'array' => ':attribute musí být pole.',
    'ascii' => ':attribute musí obsahovat pouze alfanumerické znaky a symboly.',
    'before' => ':attribute musí být datum před :date.',
    'before_or_equal' => ':attribute musí být datum před nebo rovno :date.',
    'between' => [
        'array' => ':attribute musí mít od :min do :max položek.',
        'file' => ':attribute musí mít od :min do :max kilobajtů.',
        'numeric' => ':attribute musí mít od :min do :max.',
        'string' => ':attribute musí mít od :min do :max znaků.',
    ],
    'boolean' => ':attribute pole musí být nastaven na ano nebo ne.',
    'can' => ':attribute obsahuje nesprávnou hodnotu.',
    'confirmed' => ':attribute potvrzení se neshoduje.',
    'current_password' => 'Heslo je nesprávné.',
    'date' => ':attribute musí být platné datum.',
    'date_equals' => ':attribute musí být datum rovné :date.',
    'date_format' => ':attribute se musí shodovat s formátem :format.',
    'decimal' => ':attribute musí mít :decimal desetinná místa.',
    'declined' => ':attribute musí být odepřen.',
    'declined_if' => ':attribute musí být odepřen, když :other je :value.',
    'different' => ':attribute a :other musí být odlišné.',
    'digits' => ':attribute musí obsahovat číslice :digits.',
    'digits_between' => ':attribute musí být mezi :min a :max číslicemi.',
    'dimensions' => ':attribute má neplatné rozměry obrázku.',
    'distinct' => ':attribute má duplicitní hodnotu.',
    'doesnt_end_with' => ':attribute nesmí končit jedním z následujících výrazů: :values.',
    'doesnt_start_with' => ':attribute nesmí začínat jedním z následujících výrazů: :values.',
    'email' => ':attribute musí být platná e-mailová adresa.',
    'ends_with' => ':attribute musí končit jedním z následujících výrazů: :values.',
    'enum' => 'Vybraný :attribute je neplatný.',
    'exists' => 'Vybraný :attribute je neplatný.',
    'extensions' => ':attribute musí mít jedno z následujících rozšíření: :values.',
    'file' => ':attribute musí být soubor.',
    'filled' => ':attribute musí mít hodnotu.',
    'gt' => [
        'array' => ':attribute musí mít více než :value položek.',
        'file' => ':attribute musí mít více než :value kilobajtů.',
        'numeric' => ':attribute musí být větší než :value.',
        'string' => ':attribute musí být delší než :value znaků.',
    ],
    'gte' => [
        'array' => ':attribute musí obsahovat položky :value nebo větší.',
        'file' => ':attribute musí mít více nebo stejně jako :value kilobajtů.',
        'numeric' => ':attribute musí být větší nebo roven :value.',
        'string' => ':attribute musí mít více nebo stejně znaků :value.',
    ],
    'hex_color' => ':attribute musí mít platnou barvu v HEX kódu.',
    'image' => ':attribute musí být obrázek.',
    'in' => 'Vybraný :attribute je neplatný.',
    'in_array' => ':attribute musí existovat v :other.',
    'integer' => ':attribute musí být celé číslo.',
    'ip' => ':attribute musí být platná IP adresa .',
    'ipv4' => ':attribute musí být platná IPv4 adresa .',
    'ipv6' => ':attribute musí být platná IPv6 adresa .',
    'json' => ':attribute musí být platný JSON řetězec.',
    'lowercase' => ':attribute musí obsahovat malá písmena.',
    'lt' => [
        'array' => ':attribute musí mít méně než :value položek.',
        'file' => ':attribute musí mít méně než :value kilobajtů.',
        'numeric' => ':attribute musí být menší než :value.',
        'string' => ':attribute musí mít méně znaků než :value.',
    ],
    'lte' => [
        'array' => ':attribute nesmí mít více než :value položek.',
        'file' => ':attribute musí mít méně nebo stejně kilobajtů jako :value.',
        'numeric' => ':attribute musí být menší nebo rovný :value.',
        'string' => ':attribute musí mít méně nebo stejně znaků jako :value.',
    ],
    'mac_address' => ':attribute musí být platná MAC adresa.',
    'max' => [
        'array' => ':attribute nesmí mít více než :max položek.',
        'file' => ':attribute nesmí mít více než :max kilobajtů.',
        'numeric' => ':attribute nesmí být větší než :max.',
        'string' => ':attribute nesmí mít více než :max znaků.',
    ],
    'max_digits' => ':attribute nesmí mít více než :max číslic.',
    'mimes' => ':attribute musí být soubor typu: :values.',
    'mimetypes' => ':attribute musí být soubor typu: :values.',
    'min' => [
        'array' => ':attribute musí mít alespoň :min položek.',
        'file' => ':attribute musí mít alespoň :min kilobajtů.',
        'numeric' => ':attribute musí být minimálně :min.',
        'string' => ':attribute musí mít alespoň :min znaků.',
    ],
    'min_digits' => ':attribute musí mít alespoň :min číslic.',
    'missing' => ':attribute musí být prázdné.',
    'missing_if' => ':attribute musí být prázdný, když :other je :value.',
    'missing_unless' => ':attribute musí být prázdný, pokud :other není :value.',
    'missing_with' => ':attribute musí být prázdný, když je :values ​​k dispozici.',
    'missing_with_all' => ':attribute musí být prázdný, pokud jsou :values ​​k dispozici.',
    'multiple_of' => ':attribute musí být násobkem hodnoty :value.',
    'not_in' => 'Vybraný :attribute je neplatný.',
    'not_regex' => 'Formát :attribute je neplatný.',
    'numeric' => ':attribute musí být číslo.',
    'password' => [
        'letters' => ':attribute musí obsahovat alespoň jedno písmeno.',
        'mixed' => ':attribute musí obsahovat alespoň jedno velké a jedno malé písmeno.',
        'numbers' => ':attribute musí obsahovat alespoň jedno číslo.',
        'symbols' => ':attribute musí obsahovat alespoň jeden symbol.',
        'uncompromised' => 'Toto heslo :attribute se objevilo při úniku dat. Vyberte jiné :attribute.',
    ],
    'present' => ':attribute musí být zadán.',
    'present_if' => ':attribute musí být zadán, když :other je :value.',
    'present_unless' => ':attribute musí být zadán, pokud :other není :value.',
    'present_with' => ':attribute musí byť zadaný, keď je zadaný :values.',
    'present_with_all' => ':attribute musí být zadán, když jsou zadány :values.',
    'prohibited' => ':attribute je zakázán.',
    'prohibited_if' => ':attribute je zakázáno, když :other je :value.',
    'prohibited_unless' => ':attribute je zakázán, pokud :other není v :values.',
    'prohibits' => ':attribute zakazuje přítomnost :other.',
    'regex' => ':attribute formát pole je neplatný.',
    'required' => ':attribute je povinen.',
    'required_array_keys' => ':attribute musí obsahovat položky pro: :values.',
    'required_if' => ':attribute je povinen, když :other je :value.',
    'required_if_accepted' => ':attribute je povinen, když je akceptováno :other.',
    'required_unless' => ':attribute je povinný, pokiaľ :other nie je v :values.',
    'required_with' => ':attribute je povinen, když je :values ​​k dispozici',
    'required_with_all' => ':attribute je povinen, když jsou hodnoty :values ​​k dispozici.',
    'required_without' => ':attribute je povinen, když :values ​​není k dispozici.',
    'required_without_all' => ':attribute je povinen, pokud není k dispozici žádná z hodnot :values.',
    'same' => ':attribute se musí shodovat s :other.',
    'size' => [
        'array' => ':attribute musí obsahovať položky :size.',
        'file' => ':attribute musí mít :size kilobajtů.',
        'numeric' => ':attribute musí být :size.',
        'string' => ':attribute musí obsahovat znaky :size.',
    ],
    'starts_with' => ':attribute musí začínat jedním z následujících výrazů: :values.',
    'string' => ':attribute musí být řetězec.',
    'timezone' => ':attribute musí být platné časové pásmo.',
    'unique' => ':attribute již byl použit.',
    'uploaded' => 'Nepodařilo se nahrát :attribute.',
    'uppercase' => ':attribute musí obsahovat velká písmena.',
    'url' => ':attribute musí být platná adresa URL.',
    'ulid' => ':attribute musí být platným ULID.',
    'uuid' => ':attribute musí být platným UUID.',
    'required_without_label' => 'Vyplňte toto povinné pole.',
    'recaptcha' => 'Ověření ReCaptcha selhalo.',
    'numeric_field' => ':attribute není platné číslo, zadejte platné číslo, například 1200, 1200.00 nebo 1200.255.',
    'calling_prefix' => ':attribute musí začínat platnou předvolbou země, například: +420',
    'required_file' => 'Přidejte soubor.',
    'invalid_options' => 'Poskytnutá možnost ":options" je neplatná. | Poskytnuté možnosti ":options" jsou neplatné.',
    'custom' => [
        'notifications' => [
            '*' => [
                'email' => 'Zadejte platnou e-mailovou adresu.',
                'filled' => 'Zadejte e-mailovou adresu.',
            ],
        ],
        '_privacy-policy' => [
            'accepted' => 'Musíte přijmout zásady ochrany osobních údajů',
        ],
    ],
    'import' => [
        'user' => [
            'invalid' => 'Poskytli jste uživatele, který neexistuje. Musíte přidat ID uživatele nebo celé uživatelské jméno.',
        ],
    ],
    'attributes' => [
    ],
];
